#include "joueur.h"

// Rglages pour le mode normal
int Joueur::m_iForceTaperX=0;
int Joueur::m_iForceTaperY=0;
int Joueur::m_iStun=0;
int Joueur::m_iForceSaut=0;
int Joueur::m_iForceMarcher=0;
int Joueur::m_iTempsPosage=0;
int Joueur::m_iCoeffSaut=0;

// Rglages pour le mode furie
int Joueur::m_iTempsFurie=0;
int Joueur::m_iGainFurieTaper=0;
int Joueur::m_iGainFuriePoser=0;
int Joueur::m_iGainFurieCasser=0;
int Joueur::m_iFurieForceTaperX=0;
int Joueur::m_iFurieForceTaperY=0;
int Joueur::m_iFurieStun=0;
int Joueur::m_iFurieForceSaut=0;
int Joueur::m_iFurieForceMarcher=0;
int Joueur::m_iFurieTempsPosage=0;

void Joueur::initValeurs()
{
    g_SGFichier.ouvrir("./config/gameplay.cfg");
    g_SGFichier.charger();

    // Rglages pour le mode normal
    m_iForceTaperX=g_SGFichier.lire("ForceTaperX");
    m_iForceTaperY=g_SGFichier.lire("ForceTaperY");
    m_iStun=g_SGFichier.lire("Stun");
    m_iForceSaut=g_SGFichier.lire("ForceSaut");
    m_iForceMarcher=g_SGFichier.lire("ForceMarcher");
    m_iTempsPosage=g_SGFichier.lire("TempsPosage");
    m_iCoeffSaut=g_SGFichier.lire("CoeffSaut");

    // Rglages pour le mode furie
    m_iTempsFurie=g_SGFichier.lire("TempsFurie");
    m_iGainFurieTaper=g_SGFichier.lire("GainFurieTaper");
    m_iGainFuriePoser=g_SGFichier.lire("GainFuriePoser");
    m_iGainFurieCasser=g_SGFichier.lire("GainFurieCasser");
    m_iFurieForceTaperX=g_SGFichier.lire("FurieForceTaperX");
    m_iFurieForceTaperY=g_SGFichier.lire("FurieForceTaperY");
    m_iFurieStun=g_SGFichier.lire("FurieStun");
    m_iFurieForceSaut=g_SGFichier.lire("FurieForceSaut");
    m_iFurieForceMarcher=g_SGFichier.lire("FurieForceMarcher");
    m_iFurieTempsPosage=g_SGFichier.lire("FurieTempsPosage");
    
    g_SGFichier.fermer();
}

Joueur::Joueur(char *szNom,const int iGauche,const int iDroite,
               const int iBrique,const int iTaper,const int iSauter, int iNumJoueur, bool bLocal)
{
    initSprite();    
    m_bGagnant=false;
    m_bTouche=false;
    m_bFurie=false;
    m_iScore=0;
    m_iNumJoueur=iNumJoueur;
    m_szNom = (char *)malloc(strlen(szNom)+1);
    strcpy(m_szNom, szNom);
    
    Chaine ch1(getNom());
    if ( g_pJeu->getModeJeu() == MULTI )
    {
        g_SGEvent.add(new KeyRxEvent<Joueur> (iGauche,iNumJoueur,1),ch1+"RG");
        g_SGEvent.add(new KeyRxEvent<Joueur> (iDroite,iNumJoueur,2),ch1+"RD");
        g_SGEvent.add(new KeyRxEvent<Joueur> (iBrique,iNumJoueur,3),ch1+"RB");
        g_SGEvent.add(new KeyRxEvent<Joueur> (iTaper,iNumJoueur,4),ch1+"RT");
        g_SGEvent.add(new KeyRxEvent<Joueur> (iSauter,iNumJoueur,5),ch1+"RS");
    
        g_SGEvent.add(new RxEvent<Joueur> (iNumJoueur,1,this,&Joueur::allerAGauche),ch1+"G");
        g_SGEvent.add(new RxEvent<Joueur> (iNumJoueur,2,this,&Joueur::allerADroite),ch1+"D");
        g_SGEvent.add(new RxEvent<Joueur> (iNumJoueur,3,this,&Joueur::poserBrique),ch1+"B");
        g_SGEvent.add(new RxEvent<Joueur> (iNumJoueur,4,this,&Joueur::taper),ch1+"T");
        g_SGEvent.add(new RxEvent<Joueur> (iNumJoueur,5,this,&Joueur::sauter),ch1+"S");
    }
    else
    {
        g_SGEvent.add(new KeyEvent<Joueur>(iGauche,this,&Joueur::allerAGauche),ch1+"G");
        g_SGEvent.add(new KeyEvent<Joueur>(iDroite,this,&Joueur::allerADroite),ch1+"D");
        g_SGEvent.add(new KeyEvent<Joueur>(iBrique,this,&Joueur::poserBrique),ch1+"B");
        g_SGEvent.add(new KeyEvent<Joueur>(iTaper,this,&Joueur::taper),ch1+"T");
        g_SGEvent.add(new KeyEvent<Joueur>(iSauter,this,&Joueur::sauter),ch1+"S");        
    } 
       
    g_SGTimer.add(ch1+"brique",m_iTempsPosage);
    g_SGEvent.add(new ClassicEvent<SGEvent,Joueur> (&g_SGEvent,&SGEvent::toujours,this,&Joueur::updateMarcher),ch1+"CEMarcher");
    g_SGEvent.add(new ClassicEvent<SGEvent,Joueur> (&g_SGEvent,&SGEvent::toujours,this,&Joueur::updateBrique),ch1+"CEBrique");
    g_SGEvent.add(new ClassicEvent<SGEvent,Joueur> (&g_SGEvent,&SGEvent::toujours,this,&Joueur::updateTaper),ch1+"CETaper");
    g_SGEvent.add(new ClassicEvent<SGEvent,Joueur> (&g_SGEvent,&SGEvent::toujours,this,&Joueur::updatePorte),ch1+"CEPorte");
    g_SGEvent.add(new ClassicEvent<SGEvent,Joueur> (&g_SGEvent,&SGEvent::toujours,this,&Joueur::toucher),ch1+"CETouche");
    g_SGEvent.add(new ClassicEvent<SGEvent,Joueur> (&g_SGEvent,&SGEvent::toujours,this,&Joueur::updateFurie),ch1+"CEFurie");

    getSprite()->addBmpEtat("./images/bleu.bmp",20,40,1,2,0,0,ch1+"E0");
    getSprite()->addBmpEtat("./images/bleumarcher.bmp",20,40,14,2,100,1,ch1+"E1");
    getSprite()->addBmpEtat("./images/bleubrique.bmp",45,40,10,2,30,2,ch1+"E2");
    getSprite()->setAjoutAnim(2,1,-25,0);
    getSprite()->addBmpEtat("./images/bleutaper.bmp",40,40,10,2,20,2,ch1+"E3");
    getSprite()->setAjoutAnim(3,0,-3,0);
    getSprite()->setAjoutAnim(3,1,-17,0);
    getSprite()->addBmpEtat("./images/poing.bmp",30,40,3,2,40,2,ch1+"E4");
    getSprite()->setAjoutAnim(4,1,-10,0);
    setPhysicData(new PhysicData(0,0,0,0,19,39,10.0,true,true));
    getPhysicData()->ajouterGravite();
    getPhysicData()->setVx(1);
    getPhysicData()->setFrot(BAS,0.5);
    getPhysicData()->setVmaxX(100.0);
}

Joueur::Joueur(char *szNom, int iNumJoueur, bool bLocal)
{
    initSprite();    
    m_bGagnant=false;
    m_bTouche=false;
    m_bFurie=false;
    m_iScore=0;
    m_szNom = (char *)malloc(strlen(szNom)+1);
    m_iNumJoueur=iNumJoueur;
    strcpy(m_szNom, szNom);
    Chaine ch1(getNom());
    
    g_SGEvent.add(new RxEvent<Joueur> (iNumJoueur,1,this,&Joueur::allerAGauche),ch1+"G");
    g_SGEvent.add(new RxEvent<Joueur> (iNumJoueur,2,this,&Joueur::allerADroite),ch1+"D");
    g_SGEvent.add(new RxEvent<Joueur> (iNumJoueur,3,this,&Joueur::poserBrique),ch1+"B");
    g_SGEvent.add(new RxEvent<Joueur> (iNumJoueur,4,this,&Joueur::taper),ch1+"T");
    g_SGEvent.add(new RxEvent<Joueur> (iNumJoueur,5,this,&Joueur::sauter),ch1+"S");
    
    g_SGTimer.add(ch1+"brique",m_iTempsPosage);
    g_SGEvent.add(new ClassicEvent<SGEvent,Joueur> (&g_SGEvent,&SGEvent::toujours,this,&Joueur::updateMarcher),ch1+"CEMarcher");
    g_SGEvent.add(new ClassicEvent<SGEvent,Joueur> (&g_SGEvent,&SGEvent::toujours,this,&Joueur::updateBrique),ch1+"CEBrique");
    g_SGEvent.add(new ClassicEvent<SGEvent,Joueur> (&g_SGEvent,&SGEvent::toujours,this,&Joueur::updateTaper),ch1+"CETaper");
    g_SGEvent.add(new ClassicEvent<SGEvent,Joueur> (&g_SGEvent,&SGEvent::toujours,this,&Joueur::updatePorte),ch1+"CEPorte");
    g_SGEvent.add(new ClassicEvent<SGEvent,Joueur> (&g_SGEvent,&SGEvent::toujours,this,&Joueur::toucher),ch1+"CETouche");
    g_SGEvent.add(new ClassicEvent<SGEvent,Joueur> (&g_SGEvent,&SGEvent::toujours,this,&Joueur::updateFurie),ch1+"CEFurie");

    getSprite()->addBmpEtat("./images/bleu.bmp",20,40,1,2,0,0,ch1+"E0");
    getSprite()->addBmpEtat("./images/bleumarcher.bmp",20,40,14,2,100,1,ch1+"E1");
    getSprite()->addBmpEtat("./images/bleubrique.bmp",45,40,10,2,30,2,ch1+"E2");
    getSprite()->setAjoutAnim(2,1,-25,0);
    getSprite()->addBmpEtat("./images/bleutaper.bmp",40,40,10,2,20,2,ch1+"E3");
    getSprite()->setAjoutAnim(3,0,-3,0);
    getSprite()->setAjoutAnim(3,1,-17,0);
    getSprite()->addBmpEtat("./images/poing.bmp",30,40,3,2,40,2,ch1+"E4");
    getSprite()->setAjoutAnim(4,1,-10,0);
    setPhysicData(new PhysicData(0,0,0,0,19,39,10.0,true,true));
    getPhysicData()->ajouterGravite();
    getPhysicData()->setVx(1);
    getPhysicData()->setFrot(BAS,0.5);
    getPhysicData()->setVmaxX(100.0);
}

void Joueur::allerAGauche()
{
    if ( getSprite()->getEtat() <= 1 && !m_bTouche )
    {
        if ( !getPhysicData()->getBloque(BAS) )
        {
            if ( !m_bFurie )
                getPhysicData()->ajouterForce(new Force(-m_iForceMarcher/4,0.0,1),"Gauche");
            else
                getPhysicData()->ajouterForce(new Force(-m_iFurieForceMarcher/4,0.0,1),"Gauche");        
        }
        else
        {
            int iRang;
            iRang=g_SGPhysique.testerCollision(m_iX-2,m_iY+28,1,11);
            if ( iRang != -1 && g_SGEntite.get(iRang)->getY()-m_iY>20 )
            {
                if ( g_SGPhysique.testerCollision(m_iX-2,g_SGEntite.get(iRang)->getY()-40,1,39) == -1 )
                {
                    setY(g_SGEntite.get(iRang)->getY()-40);
                    getPhysicData()->setY((float)m_iY);
                }
            }
            if ( ! m_bFurie )
                getPhysicData()->ajouterForce(new Force(-m_iForceMarcher,0.0,1),"Gauche");
            else
                getPhysicData()->ajouterForce(new Force(-m_iFurieForceMarcher,0.0,1),"Gauche");
        }
        m_pSprite->setDirection(1);
        m_pSprite->setEtat(1);
        getSprite()->animer();
    }
}

void Joueur::allerADroite()
{
    if ( getSprite()->getEtat() <= 1 && !m_bTouche )
    {
        if ( !getPhysicData()->getBloque(BAS) )
        {
            if ( !m_bFurie )
                getPhysicData()->ajouterForce(new Force(m_iForceMarcher/4,0.0,1),"Droite");        
            else
                getPhysicData()->ajouterForce(new Force(m_iFurieForceMarcher/4,0.0,1),"Droite");                    
        }
        else
        {
            int iRang;
            iRang=g_SGPhysique.testerCollision(m_iX+20,m_iY+28,1,11);
            if ( iRang != -1 && g_SGEntite.get(iRang)->getY()-m_iY>20 )
            {
                if ( g_SGPhysique.testerCollision(m_iX+20,g_SGEntite.get(iRang)->getY()-40,1,39) == -1 )
                {
                    setY(g_SGEntite.get(iRang)->getY()-40);
                    getPhysicData()->setY((float)m_iY);
                }
            }
        if ( ! m_bFurie )
            getPhysicData()->ajouterForce(new Force(m_iForceMarcher,0.0,1),"Droite");
        else
            getPhysicData()->ajouterForce(new Force(m_iFurieForceMarcher,0.0,1),"Droite");
        }
        m_pSprite->setDirection(0);
        m_pSprite->setEtat(1);
        getSprite()->animer();
    }  
}

void Joueur::sauter()
{
  if ( getPhysicData()->getBloque(BAS) && !m_bTouche )
  {
    if ( getPhysicData()->getVy(0) == 0.0 )
      if ( !m_bFurie )
        getPhysicData()->ajouterForce(new Force(0.0,-m_iForceSaut,1),"Saut");
      else
        getPhysicData()->ajouterForce(new Force(0.0,-m_iFurieForceSaut,1),"Saut");      
  }
}

void Joueur::poserBrique()
{
    Chaine ch1(getNom());
    if ( g_SGTimer.get(ch1+"brique")->pret() && !m_bTouche )
    {
         getSprite()->changerEtat(2);
         getSprite()->animer();
    }
}

void Joueur::activerFurie()
{

}

void Joueur::taper()
{
    if ( getSprite()->getEtat() <= 1 && !m_bTouche )
    {
        int iRang;
        if ( getSprite()->getDirection() == 0 )
            iRang=g_SGPhysique.testerCollision(m_iX+20,m_iY+20,10,19);
        else  if ( getSprite()->getDirection() == 1 )
            iRang=g_SGPhysique.testerCollision(m_iX-11,m_iY+20,10,19);
            
        if ( iRang != -1 )
        {
            if ( strcmp(g_SGEntite.get(iRang)->getNom(),"brique") == 0 )
            {
                 getSprite()->changerEtat(3);
                 getSprite()->animer();
            }
            else
            {
                 getSprite()->changerEtat(4);
                 getSprite()->animer();
            }
        }
        else
        {
            getSprite()->changerEtat(4);
            getSprite()->animer();
        }
    }
}

void Joueur::updateMarcher()
{
    if ( !getPhysicData()->bouge() )
    {
        if ( getSprite()->getEtat() == 1 )
        {
                getSprite()->changerEtat(0);
        }
    }
}

void Joueur::updateBrique()
{
    if ( getSprite()->getEtat() == 2 && getSprite()->animationFinie() )
    {
        getSprite()->changerEtat(0);
        if ( getSprite()->getDirection() == 0 )
        {
            int iRang;
            iRang=g_SGPhysique.testerCollision(m_iX+20,m_iY+40,31,7);
            if ( iRang != -1 && ( strcmp(g_SGEntite.get(iRang)->getNom(),"brique") == 0 || 
                                    strcmp(g_SGEntite.get(iRang)->getNom(),"sol") == 0 ) )
            {
              int iY=g_SGEntite.get(iRang)->getY()-12;
              iRang=g_SGPhysique.testerCollision(m_iX+20,iY,31,11);
              if ( iRang == -1 )
              {
                        g_SGEntite.add("brique",m_iX+20,iY,"./images/brique.bmp")->
                                setPhysicData(new PhysicData(m_iX+20,iY,0,0,31,11,10.0,false,true));
                        if ( ! m_bFurie )
                        {
                             m_iNiveauFurie+=m_iGainFuriePoser;
                        }
              }
              else if ( g_SGPhysique.testerCollision(m_iX+20,g_SGEntite.get(iRang)->getY()-12,31,11) == -1 
                            && strcmp(g_SGEntite.get(iRang)->getNom(),"brique") == 0 )
              {
                        g_SGEntite.add("brique",m_iX+20,g_SGEntite.get(iRang)->getY()-12,"./images/brique.bmp")->
                                setPhysicData(new PhysicData(m_iX+20,g_SGEntite.get(iRang)->getY()-12,0,0,31,11,10.0,false,true));
                        if ( ! m_bFurie )
                        {
                             m_iNiveauFurie+=m_iGainFuriePoser;
                        }
              }
            }
        }
        else if ( getSprite()->getDirection() == 1 )
        {
            int iRang;
            iRang=g_SGPhysique.testerCollision(m_iX-32,m_iY+40,31,7);
            if ( iRang != -1 && ( strcmp(g_SGEntite.get(iRang)->getNom(),"brique") == 0 || 
                                    strcmp(g_SGEntite.get(iRang)->getNom(),"sol") == 0 ) )
            {
              int iY=g_SGEntite.get(iRang)->getY()-12;
              iRang=g_SGPhysique.testerCollision(m_iX-32,iY,31,11);
              if ( iRang == -1 )
              {
                        g_SGEntite.add("brique",m_iX-32,iY,"./images/brique.bmp")->
                                setPhysicData(new PhysicData(m_iX-32,iY,0,0,31,11,10.0,false,true));
                        if ( ! m_bFurie )
                        {
                             m_iNiveauFurie+=m_iGainFuriePoser;
                        }
              }
              else if ( g_SGPhysique.testerCollision(m_iX-32,g_SGEntite.get(iRang)->getY()-12,31,11) == -1 
                            && strcmp(g_SGEntite.get(iRang)->getNom(),"brique") == 0 )
              {
                        g_SGEntite.add("brique",m_iX-32,g_SGEntite.get(iRang)->getY()-12,"./images/brique.bmp")->
                                setPhysicData(new PhysicData(m_iX-32,g_SGEntite.get(iRang)->getY()-12,0,0,31,11,10.0,false,true));
                        if ( ! m_bFurie )
                        {
                             m_iNiveauFurie+=m_iGainFuriePoser;
                        }
              }
            }
        }
    }
}

void Joueur::updateTaper()
{
    if ( getSprite()->getEtat() >= 3 && getSprite()->animationFinie() )
    {
      for ( int i=10 ; i <= 20 ; i+=10 )
      {
        int iRang;
        if ( getSprite()->getDirection() == 0 )
            iRang=g_SGPhysique.testerCollision(m_iX+20,m_iY+i,10,15);
        else if ( getSprite()->getDirection() == 1 )
            iRang=g_SGPhysique.testerCollision(m_iX-11,m_iY+i,10,15);
        if ( iRang >= 0 )
        {
                Entite *pE=g_SGEntite.get(iRang);
                if ( strcmp(pE->getNom(),"brique") == 0 )
                {                    
                     g_SGEntite.del(iRang);                          
                     if ( ! m_bFurie )
                          m_iNiveauFurie+=m_iGainFurieCasser;
                     i=21;
                }                
                else if ( pE->getPhysicData()->getBouge() )
                {
                    Joueur *pJ=(Joueur*)pE;
                    pJ->m_bTouche=true;
                    pJ->getPhysicData()->setVx(0.0);
                    pJ->getPhysicData()->setVy(0.0);
                    if ( !m_bFurie )
                         g_SGTimer.add((*new Chaine(pJ->getNom()))+"toucher",m_iStun);
                    else 
                         g_SGTimer.add((*new Chaine(pJ->getNom()))+"toucher",m_iFurieStun);
                         
                    if ( getSprite()->getDirection() == 0 )
                    {
                       if ( ! m_bFurie )
                         pE->getPhysicData()->ajouterForce(new Force(m_iForceTaperX,-m_iForceTaperY,10),"Voler");
                       else
                         pE->getPhysicData()->ajouterForce(new Force(m_iFurieForceTaperX,-m_iFurieForceTaperY,10),"Voler");                       
                    }
                    else if ( getSprite()->getDirection() == 1 )
                    {
                       if ( ! m_bFurie )
                         pE->getPhysicData()->ajouterForce(new Force(-m_iForceTaperX,-m_iForceTaperY,10),"Voler");
                       else
                         pE->getPhysicData()->ajouterForce(new Force(-m_iFurieForceTaperX,-m_iFurieForceTaperY,10),"Voler");
                    }
                    if ( ! m_bFurie )
                    {
                         m_iNiveauFurie+=m_iGainFurieTaper;
                    }
                    i=21;
                }                
       }                        
        getSprite()->changerEtat(0);
      }
    }
}

void Joueur::updatePorte()
{
    if ( m_iX+10 > g_SGEntite.get("porte")->getX() && m_iX+10 < g_SGEntite.get("porte")->getX() + g_SGEntite.get("porte")->getSprite()->getLargeur() )
        if ( m_iY+20 > g_SGEntite.get("porte")->getY() && m_iY+20 < g_SGEntite.get("porte")->getY() + g_SGEntite.get("porte")->getSprite()->getHauteur() 
                                && !m_bGagnant )
        {
                finRound();
                m_bGagnant=true;
                m_iScore+=1;
                g_SGEntite.get("porte")->getSprite()->animer();
        }
}

void Joueur::init()
{
    m_bGagnant=false;
    m_iNiveauFurie=0;
    m_bFurie=false;
    getSprite()->changerEtat(0);
}

void Joueur::toucher()
{
    if ( m_bTouche )
    {
        g_SGEvent.del((*new Chaine(getNom()))+"CETouche");
        g_SGEvent.add(new ClassicEvent<SGEvent,Joueur> (&g_SGEvent,&SGEvent::toujours,this,&Joueur::updateToucher),(*new Chaine(getNom()))+"CEUTouche");
    }
}

void Joueur::updateToucher()
{
    if ( g_SGTimer.get((*new Chaine(getNom()))+"toucher")->pret() )
    {
        m_bTouche=false;
        g_SGTimer.del((*new Chaine(getNom()))+"toucher");
        g_SGEvent.del((*new Chaine(getNom()))+"CEUTouche");
        g_SGEvent.add(new ClassicEvent<SGEvent,Joueur> (&g_SGEvent,&SGEvent::toujours,this,&Joueur::toucher),(*new Chaine(getNom()))+"CETouche");
    }
}

void Joueur::updateFurie()
{
    if ( g_pJeu->getModeJeu() == MULTI )
    {
        if ( strcmp(getNom(),g_szNomJoueur) == 0 )
        {
            int iX=(m_iNiveauFurie*g_SGEntite.get("furie")->getSprite()->getLargeur())/100;
            g_SGEntite.get("furie")->getSprite()->setCache(iX,g_SGEntite.get("furie")->getSprite()->getHauteur());
        }
    }
    else
    {
        if ( m_iNumJoueur == 1 )
        {
            int iX=(m_iNiveauFurie*g_SGEntite.get("furie")->getSprite()->getLargeur())/100;
            g_SGEntite.get("furie")->getSprite()->setCache(iX,g_SGEntite.get("furie")->getSprite()->getHauteur());        
        }
        else
        {
            int iX=(m_iNiveauFurie*g_SGEntite.get("furie2")->getSprite()->getLargeur())/100;
            g_SGEntite.get("furie2")->getSprite()->setCache(iX,g_SGEntite.get("furie2")->getSprite()->getHauteur());        
        }       
    }
        
    Chaine ch1(getNom());
    if ( m_iNiveauFurie >= 100 && ! m_bFurie)
    {
        m_bFurie=true;
        m_iNiveauFurie=100;
        g_SGTimer.add(ch1+"furie",m_iTempsFurie);
        g_SGEntite.add(ch1+"vener",m_iX-10,m_iY-10,"./images/vener.bmp");
        g_SGTimer.get(ch1+"brique")->setDuree(m_iFurieTempsPosage);
    }
    if ( g_SGTimer.get(ch1+"furie") != NULL )
        if ( g_SGTimer.get(ch1+"furie")->pret() )
        {
                m_bFurie=false;
                m_iNiveauFurie=0;
                g_SGTimer.del(ch1+"furie");
                g_SGEntite.del(ch1+"vener");
                g_SGTimer.get(ch1+"brique")->setDuree(m_iTempsPosage);
        }
    if ( m_bFurie )
    {
        g_SGEntite.get(ch1+"vener")->setX(m_iX-10);
        g_SGEntite.get(ch1+"vener")->setY(m_iY-10);
        m_iNiveauFurie=100-g_SGTimer.get(ch1+"furie")->getTempsRestant()/100;
    }

}
